
include("decomposition.jl")

using LightGraphs
using TickTock
using SparseArrays

#Inp = "football.mtx"
Inp = "M2.mtx"

io = open(Inp, "r")
rr = zeros(Int, 0)
cc = zeros(Int, 0)
vv = zeros(Float64, 0)
while !eof(io)
    ln = readline(io)
    sp = split(ln)
    r = parse(Int, sp[1])
    c = parse(Int, sp[2])
    #v = parse(Int, sp[3])
    append!(rr, r)
    append!(cc, c)
    #append!(vv, v)
end

vv = ones(Float64, length(rr))

W = copy(vv)

mg = length(rr)

R = append!(copy(rr), copy(cc))

C = append!(copy(cc), copy(rr))

V = append!(copy(vv), copy(vv))

A = sparse(R, C, V)

## L is the sparsification level;
# the larger spL results in more aggressive sparsification
# you can start with L = 4 and increase it if the results are good
L = 1

## A_new is the adjacency matrix corresponding to the coarsened simple graph
#The output of decomposition function is a clustering file.
#The clustering file of a graph with |V | vertices,
#consists of |V | lines with a single number per line.
#The i th line of the file contains the cluster number
#that the i th vertex belongs to. Cluster numbers start from 1.

## NF is the given node feature as a dense matrix with the size of M * N,
# where M is the length of features and N is the number of the nodes in graph
# for example, for a graph with 10 nodes, where each node has 5 features,
# NF is a matrix with the size of 5*10 (5 rows, and 10 columns)

## alpha is a parameter to make sure you only merge the nodes with the
# same features in every level; you don't need to change this.
alpha = 1e7

NF1 = rand(5, 4)

NF = hcat(NF1, NF1, NF1, NF1)

A_new= decomposition(A, L, NF, alpha)
